*************************************************************************
BY: Jim Sullivan
CHANGE: 3/19/08: NO LONGER INCLUDE RENT2 IN TFLOW2 FOR 1980-81.  THUS, 
                 THIS MEASURE DOES NOT INLCLUDE AN IMPUTED RENT FOR THOSE
                 IN PUBLIC OR SUBS HOUSING.  WE DON'T OBSERVE WHO IS IN SUCH
                 HOUSING IN 1980-81

CHANGE: 12/18/09: EDITED TO INCLUDE 2008 DATA

CHANGE: 11/3/10: EDITED TO INCLUDE 2009 DATA

CHANGE: 10/23/11: EDITED TO INCLUDE 2010 DATA 
*************************************************************************
;

*%include "~/jim/gzipseq.mcr";

OPTIONS NOLABEL;
LIBNAME alldat '~/jim/data';
LIBNAME mymemb '~/jim/data/ce_memb';

********************************************************************************
RUN HEALTH INSURANCE PROGRAM, WHICH CREATES TEMP SAS DATASET: cons_exp80_10_plus
********************************************************************************;
%INCLUDE "~/jim/poverty/include/health_insurance.sas";

************************************************************************
MERGE IN DATA FROM STATA
FOR NOW, TAKE PRE-06 DATA FROM THE OLD VERSION OF PRED_RENT AND TAKE 
06 AND AFTER FROM THE NEW VERSION
************************************************************************;
FILENAME rentdat1 '~/jim/data/tosas_pred_rent05.raw'; 
FILENAME rentdat2 '~/jim/data/tosas_pred_rent10.raw'; 

DATA temp1;
   INFILE rentdat1 LRECL=200;
   INPUT newid v05_1 v05_2 v05_3 v05_4;
RUN;
PROC SORT;
BY newid;
RUN;

DATA temp2;
   INFILE rentdat2 LRECL=200;
   INPUT newid v10_1 v10_2 v10_3 v10_4;
RUN; 
PROC SORT;
BY newid;
RUN;
 
DATA cons_exp80_10_plus;
MERGE cons_exp80_10_plus(in=in1) temp1 temp2;
BY newid;
IF in1; 

IF qyear LE 1061 THEN DO;
   mo_rent2=v05_1; 
   mo_rent2_c=v05_2; 
   mo_rent40=v05_3; 
   mo_rent_c40=v05_4;
END;
IF qyear GE 1062 THEN DO; 
   mo_rent2=v10_1; 
   mo_rent2_c=v10_2; 
   mo_rent40=v10_3; 
   mo_rent_c40=v10_4;
END; 

DROP v05_1 v05_2 v05_3 v05_4 v10_1 v10_2 v10_3 v10_4;

 
IF ref_year GE 1983 THEN DO; 
tflow2=tflow;
IF cutenure GT 3 AND (publhous=1 OR govtcost=1) THEN
   tflow2=tflow-SUM(OF rendwepq rendwecq)+MAX(SUM(OF rendwepq rendwecq),mo_rent40*3);
tflow3=tflow;
IF cutenure GT 3 AND (publhous=1 OR govtcost=1) THEN
   tflow3=tflow-SUM(OF rendwepq rendwecq)+MAX(SUM(OF rendwepq rendwecq),mo_rent_c40*3);
END;
 
IF ref_year LE 1982 THEN DO;
   tflow2=tflow;
   tflow3=tflow;

*   RUN THIS LINE IF WANT TO INCLUDE RENT2 (IMPUTED VALUE OF RENT FOR THOSE 
    "PREDICTED TO BE" IN PUBLIC HOUSING;
*   tflow4=tflow+MAX(rent2,SUM(OF rendwepq rendwecq))-SUM(OF rendwepq rendwecq);

END; 
 
RUN; 

*%gunzipsq(~/jim/data/ce_memb,memb_age_dat80_10,all,all);

************************************************************************
MERGE IN VEHICLE DATA 
FOR NOW, TAKE PRE-06 DATA FROM THE OLD VERSION OF CAR FLOWS AND TAKE 
06 AND AFTER FROM THE NEW VERSION
************************************************************************;
PROC SORT DATA=alldat.car_values10; 
  BY srv_year newid; 
RUN; 
PROC SORT DATA=alldat.car_values05; 
  BY srv_year newid; 
RUN; 

PROC SORT DATA=cons_exp80_10_plus;
  BY srv_year newid;
RUN;

PROC SORT DATA=alldat.memb_age_dat80_10;
  BY srv_year newid;
RUN;

*MATCH RATE FOR VEHICLES=99.25, AND FOR MEMBER DATA=99.85; 
*ALL 346 NON MATCHES FOR MEMBER DATA ARE FOR QYEAR 812-814;
*MEMBER DATA MATCH PERSOT64 IN 99.9% OF CASES EXCEPT IN 812 WHERE 683 DON'T MATCH;

DATA alldat.cons_exp80_10_plus_veh_memb;
MERGE cons_exp80_10_plus(IN=in1) alldat.memb_age_dat80_10 
                                 alldat.car_values10(KEEP=srv_year newid num_cars n_tot_vflow1
                                        RENAME=(num_cars=c10 n_tot_vflow1=f10))
                                 alldat.car_values05(KEEP=srv_year newid num_cars n_tot_vflow1
                                        RENAME=(num_cars=c05 n_tot_vflow1=f05));
   BY srv_year newid;
   IF in1;

IF qyear LE 1061 THEN DO;
   num_cars=c05;
   n_tot_vflow1=f05;
END;
IF qyear GE 1062 THEN DO;
   num_cars=c10;
   n_tot_vflow1=f10;
END;

DROP c05 c10 f05 f10;

IF num_cars=. THEN num_cars=0;
IF n_tot_vflow1=. THEN n_tot_vflow1=0;
ELSE n_tot_vflow1=n_tot_vflow1/4;
 
diff=num_cars-vehq;

diff2=persot64-SUM(OF asm_dum1-asm_dum16);

RUN;

proc means;
run;
proc freq;
table diff diff2;
run;
proc freq;
where diff NE 0 and diff NE .;
table qyear;
run;
proc freq;
where diff2 NE 0 and diff2 NE .;
table qyear;
run;

proc means;
where fam_size NE . AND asm_dum1=.;
run;

proc freq;
where fam_size NE . AND asm_dum1=.;
table srv_year qyear;
run;

*%gzipsq(work,cons_exp80_10_plus_veh_memb,~/jim/data);


